*__TESTVDU____________________________________________________________________________________________
*
*
*  TESTVDU
*     Test 6809 Bus Bridge and VDU interface
*____________________________________________________________________________________________________
; constants

OSRAM		EQU       $0000
OSEND		EQU       $CBFF
OSUTIL		EQU       $C000

PORTA		EQU       $F01F
PORTB		EQU       $F010
PORTC		EQU       $F02F    

DDRA		EQU       $F013
DDRB		EQU       $F012
DDRC		EQU       $F023

IDELO		EQU       $F120			; DATA PORT (LOW BYTE)
IDEERR		EQU       $F121			; READ: ERROR REGISTER; WRITE: PRECOMP
IDESECTC	EQU       $F122			; SECTOR COUNT
IDESECTN	EQU       $F123			; SECTOR NUMBER
IDECYLLO	EQU       $F124			; CYLINDER LOW
IDECYLHI	EQU       $F125			; CYLINDER HIGH
IDEHEAD		EQU       $F126			; DRIVE/HEAD
IDESTTS		EQU       $F127			; READ: STATUS; WRITE: COMMAND
IDEHI		EQU       $F128			; DATA PORT (HIGH BYTE)
IDECTRL		EQU       $F12E			; READ: ALTERNATIVE STATUS; WRITE; DEVICE CONTROL
IDEADDR		EQU       $F12F			; DRIVE ADDRESS (READ ONLY)

READR		EQU	$F1F0
WRITR		EQU	$F1F1
SY6545S		EQU	$F1F2
SY6545D		EQU	$F1F3



		ORG       $0000

*____________________________________________________________________________________________________


		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'START VDU TEST PROGRAM'
		FCB	$00			; Line terminator


CRT_INIT:
	LDX	#TAB6545	; X POINTER TO THE NEXT INIT VALUES
	CLRA	A		; A=0

CRT_INIT_LOOP:
	STAA	$F1F2		; $F1F2 SET REGISTER
	NOP
	NOP

	
	LDB	,X+		; LOAD THE NEXT INIT VALUE IN D
	STAB	$F1F3		; $F1F3 ADDRESS
	SWI
	FCB	27
	SWI
	FCB	22

	INCA			; REGISTER + 1
	CMPA	#$10
	BNE	CRT_INIT_LOOP	; LOOP FOR 16 REGISTERS
	JMP 	ENDPROGRAM

; PUT A SPACE CHARACTER AT THE FIRST TWO LOCATIONS

	LDAA	#18		; REGISTER 18
	STAA	SY6545S		; SELECT IT
	LDAA	#0		; LOAD 0
	STAA	SY6545D		; IN REGISTER 18

	LDAA	#19		; REGISTER 19
	STAA	SY6545S		; SELECT IT
	LDAA	#0		; LOAD 0
	STAA	SY6545D		; IN REGISTER 19

	LDAA	#31		; REGISTER 31
	STAA	SY6545S		; SELECT IT (NOW THE NEW POINTER WILL BE USED)

WAITFORUPDATE1:
	LDAA	SY6545S	; READ ADDRESS/STATUS REGISTER
	ANDA 	#%10000000
	BNE	UPDATEREADY1	
	JMP	WAITFORUPDATE1	;

UPDATEREADY1:
	LDAA	#32		; LOAD ' ' (SPACE CHARACTER)
	STAA	WRITR		; 

WAITFORUPDATE2:
	LDAA	SY6545S		; READ ADDRESS/STATUS REGISTER
	ANDA 	#%10000000
	BNE	UPDATEREADY2	;
	JMP	WAITFORUPDATE2	;

UPDATEREADY2:
	LDAA	#32		; LOAD ' ' (SPACE CHARACTER)
	STAA	WRITR		; 


	LDAB	#$00
CLEARSPACE:

WAITFORUPDATE3:
	LDAA	SY6545S		; READ ADDRESS/STATUS REGISTER
	ANDA 	#%10000000
	BNE	UPDATEREADY3	;
	JMP	WAITFORUPDATE3	;

UPDATEREADY3:
	STAB	WRITR		; 
	INCB
	CMPB	#$FF
	BNE  	CLEARSPACE

ENDPROGRAM:
		SWI
		FCB	25			; OUTPUT MESSAGE
		FCC	'END vdu TEST PROGRAM'
		FCB	$00			; Line terminator
		SWI
		FCB	$00			; EXIT PROGRAM





TAB6545:
     FCB	$7F,$50,$60,$0C,$1E,$02,$18,$1C,$78,$09,$60,$09,$00,$00,$00,$00
	